unit GUIMain;

interface

uses
  AspellHeadersDyn,
  Registry,
  Messages,
  Windows, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, ImgList, StdActns,
  ActnList, ToolWin;

function iswalpha(c:integer):integer;
  stdcall; external 'msvcrt.dll';

type
  TLogoAppForm = class(TForm)
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    ToolBar1: TToolBar;
    ToolButton9: TToolButton;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ActionList1: TActionList;
    FileNew1: TAction;
    FileOpen1: TAction;
    FileSave1: TAction;
    FileSaveAs1: TAction;
    FileSend1: TAction;
    FileExit1: TAction;
    EditCut1: TEditCut;
    EditCopy1: TEditCopy;
    EditPaste1: TEditPaste;
    HelpAbout1: TAction;
    StatusBar: TStatusBar;
    ImageList1: TImageList;
    RichEdit1: TRichEdit;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    N1: TMenuItem;
    FileSendItem: TMenuItem;
    N2: TMenuItem;
    FileExitItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    Help1: TMenuItem;
    HelpAboutItem: TMenuItem;
    mmOptions: TMenuItem;
    mmCheck: TMenuItem;
    pmSuggestions: TPopupMenu;
    pmSuggestionsIgnore: TMenuItem;
    pmSuggestionsReplace: TMenuItem;
    pmSuggestionsAdd: TMenuItem;
    pmSuggestionsAbort: TMenuItem;
    pmSuggestionsIgnoreAll: TMenuItem;
    pmSuggestionsReplaceAll: TMenuItem;
    pmSuggestionsAddLower: TMenuItem;
    pmSuggestionsExit: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    pmSuggestionsWord: TMenuItem;
    TimerWatchPopUp: TTimer;
    mmOptionsView: TMenuItem;
    mmOptionsDictionary: TMenuItem;
    mmOptionsEdit: TMenuItem;
    globalaspellconf1: TMenuItem;
    personalaspellconf1: TMenuItem;
    personalwordlist1: TMenuItem;
    personalreplacementlist1: TMenuItem;
    newaspellconf1: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    FontDialog1: TFontDialog;
    Font1: TMenuItem;
    procedure FileNew1Execute(Sender: TObject);
    procedure FileOpen1Execute(Sender: TObject);
    procedure FileSave1Execute(Sender: TObject);
    procedure FileSaveAs1Execute(Sender: TObject);
    procedure FileSend1Execute(Sender: TObject);
    procedure FileExit1Execute(Sender: TObject);
    procedure HelpAbout1Execute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure mmCheckClick(Sender: TObject);
    procedure pmSuggestionsItemClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerWatchPopUpTimer(Sender: TObject);
    procedure OptionsEditItemClick(Sender: TObject);
    procedure RichEdit1Change(Sender: TObject);
    procedure newaspellconf1Click(Sender: TObject);
    procedure Font1Click(Sender: TObject);
  private
    FFileName: String;
    WordStart : integer;
    WordEnd : integer;
    WordStartNext : integer;
    curlin:string;
    SuggestionResult:integer;
    SuggestionText:string;
    SuggestionCount:integer;
    SuggestionSubMenu:TMenuItem;
    wasModified:boolean;
    initdone:boolean; // RichEdit gets "Modified" after leaving FormCreate
    function isChar(c:char):boolean;
    procedure DictMenuClick(Sender:TObject);
    function DictFromMenu:string;
    procedure getDictionaries;
    procedure getConfigStringsNew;
    procedure getConfigStrings(cnf:AspellConfig);
    procedure SpellCheck;
    function GetNextWord(var sWord:string):boolean;
    procedure AdvanceWord;
    procedure InitSuggestionMenu(sWord:string);
    procedure AddToSuggestionMenu(suggestion:string);
    function ShowSuggestionMenu:integer;
    procedure ReplaceNextWord(Substitution:string);
    procedure HighlightNextWord(highlight:boolean);
    function LoadFile(Filename:string):boolean ;
procedure SetAppTitle;
  public
  end;

var
  LogoAppForm: TLogoAppForm;

implementation

uses SysUtils, Mapi, About;

{$R *.DFM}

//##############################################################################
//
//                                                    Original Win95/98 logo app
//
//##############################################################################

resourcestring
  SUntitled  = 'Untitled';
  SOverwrite = 'OK to overwrite %s';
  SSendError = 'Error while sending Mail';

procedure TLogoAppForm.FileNew1Execute(Sender: TObject);
begin
  FFileName := SUntitled;
  RichEdit1.Lines.Clear;
  RichEdit1.Modified := False;
  SetAppTitle;
end;

procedure TLogoAppForm.FileOpen1Execute(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    LoadFile(OpenDialog.FileName);
    RichEdit1.ReadOnly := ofReadOnly in OpenDialog.Options;
  end;
end;

procedure TLogoAppForm.FileSave1Execute(Sender: TObject);
begin
  if FFileName = SUntitled then
    FileSaveAs1Execute(Sender)
  else
  begin
    RichEdit1.Lines.SaveToFile(FFileName);
    RichEdit1.Modified := False;
    SetAppTitle;
  end;
end;

procedure TLogoAppForm.FileSaveAs1Execute(Sender: TObject);
begin
  if SaveDialog.Execute then
  begin
    if FileExists(SaveDialog.FileName) then
      if MessageDlg(Format(SOverwrite, [SaveDialog.FileName]),
        mtConfirmation, mbYesNoCancel, 0) <> idYes then Exit;
    RichEdit1.Lines.SaveToFile(SaveDialog.FileName);
    FFileName := SaveDialog.FileName;
    RichEdit1.Modified := False;
    SetAppTitle;
  end;
end;

procedure TLogoAppForm.FileSend1Execute(Sender: TObject);
var
  MapiMessage: TMapiMessage;
  MError: Cardinal;
begin
  with MapiMessage do
  begin
    ulReserved := 0;
    lpszSubject := nil;
    lpszNoteText := PChar(RichEdit1.Lines.Text);
    lpszMessageType := nil;
    lpszDateReceived := nil; 
    lpszConversationID := nil;
    flFlags := 0;
    lpOriginator := nil;
    nRecipCount := 0;
    lpRecips := nil;
    nFileCount := 0;
    lpFiles := nil;
  end;

  MError := MapiSendMail(0, 0, MapiMessage,
    MAPI_DIALOG or MAPI_LOGON_UI or MAPI_NEW_SESSION, 0);
  if MError <> 0 then MessageDlg(SSendError, mtError, [mbOK], 0);
end;

procedure TLogoAppForm.FileExit1Execute(Sender: TObject);
begin
  Close;
end;

procedure TLogoAppForm.HelpAbout1Execute(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

//##############################################################################
//
//                                                        Spell checking related
//
//##############################################################################

procedure TLogoAppForm.SetAppTitle;
begin
  if not initdone then
  begin
    RichEdit1.Modified := false;
    initdone:=true;
  end;

  if not RichEdit1.Modified and wasModified
  then wasModified:=false;

  if RichEdit1.Modified
  then
  begin
    //if FFilename = ''
    //then Caption := ExtractFileName(ParamStr(0))
    //else Caption := FFilename + ' * - ' + ExtractFileName(ParamStr(0));
    Caption := FFilename + ' * - ' + ExtractFileName(ParamStr(0));
  end
  else
  begin
    Application.Title := ExtractFileName(FFilename) + ' - ' + ExtractFileName(ParamStr(0));
    Caption := FFilename + ' - ' + ExtractFileName(ParamStr(0));
  end;
end;

function TLogoAppForm.LoadFile(Filename:string):boolean ;
var res:integer;
begin
  if RichEdit1.Modified then
  begin
  BringToFront;
    res := MessageBox( Handle,
                       'The text has been changed. Do you want to abort?',
                       'Save changes?',
                       MB_YESNO or MB_ICONWARNING ) ;
    if res = idYes then exit;
  end;

  Filename := StringReplace(Filename, '/', '\', [rfReplaceAll]);
  Filename := StringReplace(Filename, '\\', '\', [rfReplaceAll]);
  FFilename := Filename;
  if not FileExists(FFilename)
  then RichEdit1.Clear
  else RichEdit1.Lines.LoadFromFile(FFilename);
  RichEdit1.SetFocus;
  RichEdit1.Modified := False;
  wasModified := false;
  SetAppTitle;
  Result:=FileExists(FFilename);
end;

//------------------------------------------------------------------------------
// Spell checking stuff
//------------------------------------------------------------------------------

procedure TLogoAppForm.getDictionaries;
var
  cnf : AspellConfig;
  dict_info_list : AspellDictInfoList;
  dict_info_elements : AspellDictInfoEnumeration;
  dict_info : TAspellDictInfo;
  new_menu : TMenuItem;
  i:integer;
begin
  i:=0;
  cnf := new_aspell_config();
  dict_info_list := get_aspell_dict_info_list( cnf );
  delete_aspell_config(cnf);
  dict_info_elements := aspell_dict_info_list_elements( dict_info_list );
  repeat
    inc(i);
    dict_info := aspell_dict_info_enumeration_next( dict_info_elements )^;
    new_menu := TMenuItem.Create(mmOptionsDictionary);
    new_menu.Caption := dict_info.name;
    new_menu.RadioItem := true;
    new_menu.GroupIndex := 1;
    new_menu.Checked := (i=1);
    new_menu.OnClick := DictMenuClick;
    mmOptionsDictionary.Add(new_menu);
  until (aspell_dict_info_enumeration_at_end( dict_info_elements ) <> 0);
  delete_aspell_dict_info_enumeration(dict_info_elements);
end;

procedure TLogoAppForm.getConfigStringsNew;
var
  cnf : AspellConfig;
begin
  cnf := new_aspell_config();
  aspell_config_replace(cnf, 'lang', PChar(DictFromMenu));
  getConfigStrings(cnf);
  delete_aspell_config(cnf);
end;

procedure TLogoAppForm.getConfigStrings(cnf : AspellConfig);
var
  key_info_elements : AspellKeyInfoEnumeration;
  new_menu : TMenuItem;
  key_info : AspellKeyInfo;
  key_val : PChar;
  s : string;
begin
  while mmOptionsView.Count > 0
  do mmOptionsView.Delete(0);
  key_info_elements := aspell_config_possible_elements(cnf, 0);
  repeat
    key_info := aspell_key_info_enumeration_next( key_info_elements );
    if (key_info = NIL)
    then break;
    s := key_info.name;
    key_val := aspell_config_retrieve( cnf, key_info.name );
    s := s + '=' + key_val + ' ';
    case key_info.type_ of
      AspellKeyInfoString: s := s + ' (String)' ;
      AspellKeyInfoInt:    s := s + ' (Int)' ;
      AspellKeyInfoBool:   s := s + ' (Bool)' ;
      AspellKeyInfoList:   s := s + ' (List)' ;
    end;
    if assigned(key_info.def)
    then s:=s+' '+key_info.def;
    if assigned(key_info.desc)
    then s:=s+' '+key_info.desc;
    new_menu := TMenuItem.Create(mmOptionsView);
    new_menu.Caption := Copy(key_info.name+'='+key_val, 1, 64);
    new_menu.Hint := key_info.desc;
    mmOptionsView.Add(new_menu);
// FIXME: aspell_key_info_enumeration_at_end() doesn't work. workaround: key_info=NIL -> break
  until (aspell_key_info_enumeration_at_end(key_info_elements) <> 0);
end;

procedure TLogoAppForm.SpellCheck;
var
  cnf : AspellConfig;
  res : integer;
  possible_err  : AspellCanHaveError;
  spell_checker : AspellSpeller;
  suggestions   : AspellWordList;
  elements      : AspellStringEnumeration;
  word_ : PChar;
  sWord : string;
  err : AspellError;
begin
  cnf := new_aspell_config();
  aspell_config_replace(cnf, 'lang',PChar(DictFromMenu));
  getConfigStrings(cnf);
  possible_err := new_aspell_speller(cnf);
  if (aspell_error_number(possible_err) <> 0)
  then exit;
  spell_checker := to_aspell_speller(possible_err);
  delete_aspell_config(cnf);
  while GetNextWord(sWord) do
  begin
    res := aspell_speller_check(spell_checker, PChar(sWord), length(sWord));
    if res <> 1 then
    begin
      suggestions := aspell_speller_suggest(spell_checker, PChar(sWord), length(sWord));
      elements := aspell_word_list_elements(suggestions);
      InitSuggestionMenu(sWord);
      repeat
        word_ := aspell_string_enumeration_next(elements);
        if (word_<>NIL)
        then AddToSuggestionMenu(word_);
      until (word_ = NIL);
      delete_aspell_string_enumeration(elements);
      HighlightNextWord(true);
      case ShowSuggestionMenu of
        0 : break;   // Escape pressed
        1 : ;        // Ignore
        2 :          // Ignore all
            aspell_speller_add_to_session(spell_checker,
                   PChar(sWord), length(sWord));
//      3 : Beep;    // Replace
//      4 : Beep;    // Replace all
        5 :          // Add
            aspell_speller_add_to_personal(spell_checker,
                   PChar(sWord), length(sWord));
        6 :          // Add Lower
            aspell_speller_add_to_personal( spell_checker,
                   PChar(LowerCase(sWord)), length(sWord));
        7 : break ;  // Abort
        8 : break ;  // Exit
      100..MAXINT :  // suggestion
            begin
              HighlightNextWord(false);
              ReplaceNextWord(SuggestionText);
              aspell_speller_store_replacement(spell_checker,
                    PChar(sWord), length(sWord),
                    PChar(SuggestionText), length(SuggestionText));
            end;
      end;
    end;
    HighlightNextWord(false);
    AdvanceWord;
  end;
  HighlightNextWord(false); // if cancelled
  aspell_speller_save_all_word_lists(spell_checker);
  delete_aspell_speller(spell_checker);
end;

//------------------------------------------------------------------------------
// Spell checking / Suggestion menu
//------------------------------------------------------------------------------

procedure TLogoAppForm.InitSuggestionMenu(sWord:string);
var
   i:integer;
begin
  i:=0;
  while (i < pmSuggestions.Items.Count) do
  begin
    if pmSuggestions.Items[i].Tag >= 100
    then pmSuggestions.Items.Delete(i)
    else inc(i);
  end;
  pmSuggestionsWord.Caption := ' = ' + sWord + ' = ';
  SuggestionCount:=0;
end;

procedure TLogoAppForm.AddToSuggestionMenu(suggestion:string);
var
   new_item:TMenuItem;
   new_sub:TMenuItem;
begin
  inc(SuggestionCount);
  if ((SuggestionCount mod 10) = 0) and (SuggestionCount > 0)
  then
  begin
    new_sub:=TMenuItem.Create(pmSuggestions);
    new_sub.Caption := '&More...';
    new_sub.Tag     := 100;
    if SuggestionCount = 10
    then pmSuggestions.Items.Add(new_sub)
    else SuggestionSubMenu.Add(new_sub);
    SuggestionSubMenu := new_sub;
  end;

  new_item := TMenuItem.Create(pmSuggestions);
  new_item.Caption := '&' + IntToStr(SuggestionCount mod 10) + ' ' + suggestion;
  new_item.Tag     := 100 + SuggestionCount;
  new_item.OnClick := pmSuggestionsItemClick;

  if SuggestionCount < 10
  then pmSuggestions.Items.Add(new_item)
  else SuggestionSubMenu.Add(new_item);
end;

function TLogoAppForm.ShowSuggestionMenu:integer;
begin
  SuggestionResult := -1;
  pmSuggestions.Popup(Left + Width, Top);
  // wait for menu to close, timer needed to catch close without selecting an entry
  TimerWatchPopUp.Enabled := true;
  while ( SuggestionResult < 0 )
  do Application.ProcessMessages;
  Result := SuggestionResult;
end;

procedure TLogoAppForm.TimerWatchPopUpTimer(Sender: TObject);
begin
  if not IsWindowVisible(pmSuggestions.Handle)
  and (SuggestionResult < 0)
  then
  begin
    TimerWatchPopUp.Enabled := false;
    SuggestionResult := 0;
  end;
end;

//------------------------------------------------------------------------------

procedure TLogoAppForm.pmSuggestionsItemClick(Sender: TObject);
var MenuItem:TMenuItem;
begin
  TimerWatchPopUp.Enabled:=false;
  MenuItem:=TMenuItem(Sender);
  SuggestionResult:=MenuItem.Tag;
  SuggestionText:=Copy(MenuItem.Caption,
                       Pos(' ',MenuItem.Caption)+1, length(MenuItem.Caption));
end;

//------------------------------------------------------------------------------
// Spell checking helpers
//------------------------------------------------------------------------------

function TLogoAppForm.isChar(c:char):boolean;
var i:integer;
begin
  Result := iswalpha(ord(c)) <> 0;
end;

//------------------------------------------------------------------------------
// Spell checking / Memo/RichEdit interaction
//------------------------------------------------------------------------------

procedure TLogoAppForm.ReplaceNextWord(Substitution:string);
var
  Before, After : string;
  oldLen, newLen:integer;
begin
  oldLen := length(curlin);
  Before := Copy(curlin, 1, WordStart-1);
  After  := Copy(curlin, WordEnd+1, length(curlin));
  curlin := Before + Substitution + After;
  newLen := length(curlin);
  WordEnd       := WordEnd        + (newLen-oldLen);
  WordStartNext := WordStartNext  + (newLen-oldLen);
  RichEdit1.Lines[RichEdit1.CaretPos.y]:=curlin;
end;

function TLogoAppForm.GetNextWord(var sWord:string):boolean;
var
  i,k:integer;
  CurPos:integer;
  StartPos:integer;
  TextLen:integer;
begin
  Result := false;
  curlin:=RichEdit1.Lines[RichEdit1.CaretPos.y];
  TextLen := Length(RichEdit1.Text);
  if curlin = ''
  then
  begin
    if RichEdit1.SelStart = TextLen
    then // end of text
    begin
      beep;
      exit;
    end
    else // end of line
    begin
      RichEdit1.SelStart := RichEdit1.SelStart + 2;
      RichEdit1.Perform(WM_VSCROLL, SB_LINEDOWN , 0);
      Result := GetNextWord(sWord);
      exit;
    end;
  end;

  CurPos:=RichEdit1.CaretPos.x + 1;
  i:=CurPos;
  StartPos:=CurPos;

  // strip leading non-char
  while not isChar(curlin[i]) do
    if (i = length(curlin))
    then break
    else inc(i);
  CurPos:=i;
  WordStart := i;

  // get next word
  while isChar(curlin[i]) do
    if (i = length(curlin))
    then break
    else inc(i);
  if not isChar(curlin[i]) then dec(i);

  WordEnd := i;
  RichEdit1.SelStart:=RichEdit1.SelStart+(CurPos-StartPos);

  // strip trailing non-char
  k:=i+1;
  while (k <= length(curlin)) do //not isChar(curlin[k]) do
  if isChar(curlin[k]) //(k = length(curlin))
  then break
  else inc(k);

  WordStartNext := k;
  sWord:=Copy(curlin, CurPos, i-CurPos+1);
  Statusbar.SimpleText:='"'+sWord+'"';

  Result := true;
end;

procedure TLogoAppForm.AdvanceWord;
var offset:integer;
begin
  // set new cursor position
  if (WordStartNext = length(curlin) + 1)
  then
  begin
    offset:=1;
    RichEdit1.Perform(WM_VSCROLL, SB_LINEDOWN , 0);
  end
  else offset := -1;
  RichEdit1.SelStart := RichEdit1.SelStart + WordStartNext
                      - RichEdit1.CaretPos.x + offset ;
end;

procedure TLogoAppForm.HighlightNextWord(highlight:boolean);
begin
  RichEdit1.SelLength := WordEnd - WordStart + 1;
  if highlight
  then RichEdit1.SelAttributes.Color :=clRed
  else RichEdit1.SelAttributes.Color :=clBlack;
  RichEdit1.SelLength := 0;
end;


//------------------------------------------------------------------------------
// Spell checking / Form interaction
//------------------------------------------------------------------------------

function TLogoAppForm.DictFromMenu:string;
var i:integer;
    capt:string;
begin
  Result:= '';
  for i:=0 to mmOptionsDictionary.Count - 1 do
  begin
    if mmOptionsDictionary.Items[i].Checked
    then
    begin
      capt:=mmOptionsDictionary.Items[i].Caption;
      if Pos(' ', capt) > 0
      then Result := Copy(capt, 1, Pos(' ', capt)-1)
      else Result := capt;
      break;
    end;
  end;
end;

//------------------------------------------------------------------------------

procedure TLogoAppForm.DictMenuClick(Sender:TObject);
begin
  TMenuItem(Sender).Checked := not TMenuItem(Sender).Checked;
  getConfigStringsNew;
end;

//------------------------------------------------------------------------------
// New Form Events
//------------------------------------------------------------------------------

procedure TLogoAppForm.FormCreate(Sender: TObject);
begin
  //LoadAspell('c:\aspell\bin\aspell-15.dll');
  LoadAspell;
  RichEdit1.Align := alClient;
  FFilename:=sUntitled;
  getDictionaries;
  getConfigStringsNew;
end;

procedure TLogoAppForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin

end;

//------------------------------------------------------------------------------

procedure TLogoAppForm.mmCheckClick(Sender: TObject);
begin
  SpellCheck;
end;

procedure TLogoAppForm.OptionsEditItemClick(Sender: TObject);
var
  cnf:AspellConfig;
  globalconf,
  persconf,
  persword,
  persrepl:string;
begin
  cnf:=new_aspell_config;
  aspell_config_replace(cnf, 'lang',PChar(DictFromMenu));
  globalconf := aspell_config_retrieve(cnf, 'conf-path');
  persconf   := aspell_config_retrieve(cnf, 'per-conf-path');
  persword   := aspell_config_retrieve(cnf, 'personal-path');
  persrepl   := aspell_config_retrieve(cnf, 'repl-path');
  delete_aspell_config(cnf);
  case TMenuItem(Sender).Tag of
   0 : FFilename := globalconf;
   1 : FFilename := persconf;
   2 : FFilename := persword;
   3 : FFilename := persrepl;
  end;
  LoadFile(FFilename);
end;

procedure TLogoAppForm.RichEdit1Change(Sender: TObject);
begin
  if not wasModified
  then
  begin
    wasModified:=true;
    SetAppTitle;
  end;
end;

procedure TLogoAppForm.newaspellconf1Click(Sender: TObject);
var
    si:TStartupInfo;
    pi:TProcessInformation;
    comspec:array[0..MAX_PATH] of char;
    tmpname:string;
    reg:TRegistry;
    aspellpath:string;
    sl:TStrings;
begin
  // get shell name
  GetEnvironmentVariable('COMSPEC', comspec, SizeOf(comspec));
  // get path to aspell
  reg:=TRegistry.Create;
  reg.RootKey:=HKEY_LOCAL_MACHINE;
  reg.OpenKey('SOFTWARE\Aspell', false);
  aspellpath:=reg.ReadString('Path');
  reg.CloseKey;
  reg.Free;
  // temp file in current dir
  tmpname:=ExtractFilePath(Application.ExeName)+'tmp.txt';
  // start aspell in shell, dump config, redirected to temp file
  ZeroMemory(@si, SizeOf(si));
  si.cb:=SizeOf(si);
  si.wShowWindow:=SW_HIDE;
  si.dwFlags:=STARTF_USESHOWWINDOW;
  CreateProcess( comspec,
                 PChar('"'+ExtractFileName(comspec)+'"' + ' /c '
                       + aspellpath + '\aspell.exe config > "' + tmpname + '"'),
                 NIL, NIL, false, 0, NIL, NIL, si, pi);
  while (WaitForInputIdle(pi.hProcess, 100) = WAIT_TIMEOUT) do ;
  while (WaitForSingleObject(pi.hProcess, 100) = WAIT_TIMEOUT) do ;
  // read temp file
  sl:=TStringList.Create;
  sl.LoadFromFile(tmpname);
  RichEdit1.Lines.AddStrings(sl);
  sl.Free;
  DeleteFile(tmpname);
end;

procedure TLogoAppForm.Font1Click(Sender: TObject);
begin
  FontDialog1.Font := RichEdit1.Font;
  if FontDialog1.Execute
  then RichEdit1.Font := FontDialog1.Font;
end;

end.

